// SSIappView.h : interface of the CSSIappView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SSIAPPVIEW_H__1734D44D_1EF4_11D6_8DB5_00C04F081B46__INCLUDED_)
#define AFX_SSIAPPVIEW_H__1734D44D_1EF4_11D6_8DB5_00C04F081B46__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ParamDlg.h"

class CSSIappView : public CFormView
{
protected: // create from serialization only
	CSSIappView();
	DECLARE_DYNCREATE(CSSIappView)

public:
	//{{AFX_DATA(CSSIappView)
	enum{ IDD = IDD_SSIAPP_FORM };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Attributes
public:
	CSSIappDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSSIappView)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSSIappView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	

protected:

#define SWTRIG_PARAMNUM				0x8a
#define HOST_SWTRIG					0x08
#define EXTENDED_PARAMNUM			0xf0
#define IMAGE_FILETYPE_PARAMNUM	0x30
#define BMP_FILE_SELECTION			0x03
#define TIFF_FILE_SELECTION		0x04
#define JPEG_FILE_SELECTION		0x01
#define VIDEOVIEWFINDER_PARAMNUM		0x44

#define WM_USER_GETSWTRIGPARAM (WM_USER + 100)
#define WM_USER_GETIMAGETYPES (WM_USER_GETSWTRIGPARAM + 1)
#define WM_USER_GETVIEWFINDERPARAM (WM_USER_GETIMAGETYPES + 1)
#define WM_SENDGETVERSIONMSG			(WM_USER_GETVIEWFINDERPARAM + 1)
#define WM_SENDGETCAPABILITIESMSG			(WM_SENDGETVERSIONMSG + 1)

#define BITMAP_TYPE			0	// for m_ImageType
#define TIFF_TYPE				1
#define JPEG_TYPE				2
#define IMAGE_TYPE_UNKNOWN	3


	long Baud;
	int  Comport;
	BOOL Connected;
	BOOL m_WaitingForSnapShot;
	BOOL m_bWaitingForSWTrigParam;
	BOOL m_bWaitingForImageType;
	BOOL m_bWaitingForViewFinderParam;
	BYTE m_original_swtrigger;
	int m_ImageType;
	BOOL m_bViewFinderSupported;
	CString m_ImgFileExt;

	static CString MyMessage;
	CParamDlg *pParamDlg;
	
	void WriteImgfile(LPTSTR lpszStr, DWORD nBytes, int filetype);
	HANDLE /* HDIB */ ReadJPEGBuffer(BYTE *pBuffer, DWORD cSize);
	void ClearXferStatusMsg(void);
	void SendImageFileSelection(BYTE file_selection, int nButtonID,  int new_filetype );
	void SetupBMPforDisplay(unsigned char *pData, LPARAM l);
	void SetupTIFFforDisplay(unsigned char *pData, LPARAM l);
	void ChangeStatusBarText(CString msg);
	void ReInitialize(BOOL first_time);


	void SetupJPEGforDisplay(BYTE *pData, LPARAM l, BOOL is_video);

// Generated message map functions
protected:
	//{{AFX_MSG(CSSIappView)
	afx_msg void OnButtonPulltrigger();
	afx_msg void OnRadioConnect();
	afx_msg void OnRADIODisconnect();
	afx_msg void OnButtonReleasetrigger();
	afx_msg void OnButtonSnapshot();
	afx_msg void OnButtonVideo();
	afx_msg void OnButtonAbort();
	afx_msg void OnCheckSwtrigger();
	afx_msg void OnCheckViewfinder();
	afx_msg void OnPaint();
	afx_msg void OnRadio115baud();
	afx_msg void OnRadioCom2();
	afx_msg void OnRadioCom3();
	afx_msg void OnRadioCom4();
	afx_msg void OnRadio9600baud();
	afx_msg void OnRadio38400baud();
	afx_msg void OnRadioCom1();
	afx_msg void OnRadioJpeg();
	afx_msg void OnRadioTiff();
	afx_msg void OnRadioBmp();
	afx_msg void OnFileSaveAs();
	afx_msg void OnEditClear();
	afx_msg void OnDestroy();
	afx_msg void OnParametersGetscannerparameter();
	afx_msg void OnEditCopy();
	afx_msg void OnEditSelectAll();
	afx_msg void OnViewInterpretspecials();
	afx_msg void OnRadioBaud19200();
	afx_msg void OnButtonAbormacro();
	afx_msg void OnButtonFlushmacro();
	afx_msg void OnButtonSendcmd();
	//}}AFX_MSG
	afx_msg LRESULT OnSSIDecode(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIImage(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIxferStatus(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIVideo(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIVersion(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIError(WPARAM, LPARAM);
	afx_msg LRESULT OnSSITimeout(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIEvent(WPARAM, LPARAM);
	afx_msg LRESULT OnSSICommandCompleted(WPARAM, LPARAM);
	afx_msg LRESULT OnSSIParams(WPARAM, LPARAM);
	afx_msg LRESULT OnGetSWTrigParam(WPARAM w, LPARAM l);
	afx_msg LRESULT OnGetImageFileTypesParam(WPARAM w, LPARAM l);
	afx_msg LRESULT OnGetViewFinderParam(WPARAM w, LPARAM l);
	afx_msg LRESULT OnWM_SENDGETVERSIONMSG(WPARAM w, LPARAM l);
	afx_msg LRESULT OnWM_SENDGETCAPABILITIESMSG(WPARAM w, LPARAM l);
	afx_msg void OnPrintMyMessage(CCmdUI *pCmdUI);
	afx_msg LRESULT OnParamMessage(WPARAM w, LPARAM l);
	afx_msg LRESULT OnSSICapabilities( WPARAM w, LPARAM l);
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in SSIappView.cpp
inline CSSIappDoc* CSSIappView::GetDocument()
   { return (CSSIappDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SSIAPPVIEW_H__1734D44D_1EF4_11D6_8DB5_00C04F081B46__INCLUDED_)
